/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.breakpoints;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.Breakpoint;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class BreakpointLabelAction
implements IViewActionDelegate {
    private IViewPart fView;

    protected IViewPart getView() {
        return this.fView;
    }

    protected void setView(IViewPart view) {
        this.fView = view;
    }

    public void run(IAction action) {
        String emptyString = "";
        IStructuredSelection selection = this.getSelection();
        if (selection instanceof TreeSelection) {
            TreeSelection treeSelect = (TreeSelection)selection;
            Object object = selection.getFirstElement();
            if (object instanceof Breakpoint) {
                BreakpointsView breakpointView;
                TreeModelViewer treeViewer;
                Widget item;
                IWorkbenchPage page;
                IViewPart viewPart;
                final Breakpoint breakpoint = (Breakpoint)object;
                if (treeSelect.size() == 1 && (viewPart = (page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()).findView("org.eclipse.debug.ui.BreakpointView")) instanceof BreakpointsView && (item = (treeViewer = (breakpointView = (BreakpointsView)viewPart).getTreeModelViewer()).findItem(treeSelect.getPaths()[0])) instanceof TreeItem) {
                    Rectangle bounds;
                    final TreeItem tree = (TreeItem)item;
                    final String current = tree.getText();
                    try {
                        bounds = tree.getBounds();
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        tree.setFont(null);
                        GC gc = new GC((Drawable)tree.getParent());
                        Font currentFont = gc.getFont();
                        gc.setFont(currentFont);
                        Point textWidth = gc.textExtent(tree.getText());
                        gc.dispose();
                        bounds = tree.getBounds(0);
                        bounds.x += 10;
                        bounds.width = textWidth.x + 20;
                    }
                    final Label label = new Label((Composite)tree.getParent(), 64);
                    label.setText(ActionMessages.BreakpointLabelDialog);
                    label.setBounds(bounds.x, bounds.y - 20, label.computeSize((int)-1, (int)-1).x, label.computeSize((int)-1, (int)-1).y);
                    final Text inlineEditor = new Text((Composite)tree.getParent(), 2048);
                    inlineEditor.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
                    inlineEditor.setText(current);
                    inlineEditor.selectAll();
                    inlineEditor.setFocus();
                    inlineEditor.addListener(16, event -> {
                        tree.setText(current);
                        label.dispose();
                        inlineEditor.dispose();
                    });
                    inlineEditor.addKeyListener((KeyListener)new KeyAdapter(){

                        public void keyPressed(KeyEvent e) {
                            if (e.keyCode == 27) {
                                tree.setText(current);
                                inlineEditor.dispose();
                                label.dispose();
                            } else if (e.keyCode == 13) {
                                String newLabel = inlineEditor.getText();
                                if (!newLabel.isEmpty() && !newLabel.equals(current)) {
                                    try {
                                        breakpoint.setBreakpointLabel(newLabel);
                                    }
                                    catch (CoreException e1) {
                                        DebugUIPlugin.log(e1);
                                    }
                                } else if (newLabel.isEmpty()) {
                                    try {
                                        breakpoint.setBreakpointLabel(null);
                                    }
                                    catch (CoreException e2) {
                                        DebugUIPlugin.log(e2);
                                    }
                                }
                                inlineEditor.dispose();
                                label.dispose();
                            }
                        }
                    });
                    tree.setText(emptyString);
                }
            }
        }
    }

    protected IStructuredSelection getSelection() {
        return (IStructuredSelection)this.getView().getViewSite().getSelectionProvider().getSelection();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void init(IViewPart view) {
        this.setView(view);
    }
}

