/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts.keywordhandler;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.ui.scripts.repository.IScript;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class EventBusHandler
implements EventHandler {
    private final Map<IScript, ScriptEventHandler> fRegisteredHandlers = new HashMap<IScript, ScriptEventHandler>();

    public void handleEvent(Event event) {
        IEventBroker service = (IEventBroker)PlatformUI.getWorkbench().getService(IEventBroker.class);
        if (service != null) {
            IScript script = (IScript)event.getProperty("script");
            String topic = (String)event.getProperty("value");
            ScriptEventHandler handler = this.fRegisteredHandlers.get(script);
            if (handler != null) {
                service.unsubscribe((EventHandler)handler);
            }
            if (topic != null) {
                handler = new ScriptEventHandler(script);
                service.subscribe(topic, (EventHandler)handler);
                this.fRegisteredHandlers.put(script, handler);
            }
        }
    }

    private static class ScriptEventHandler
    implements EventHandler {
        private final IScript fScript;

        public ScriptEventHandler(IScript script) {
            this.fScript = script;
        }

        public void handleEvent(Event event) {
            IScriptEngine engine = this.fScript.prepareEngine();
            if (engine != null) {
                engine.setVariable("event", (Object)event);
                engine.schedule();
            }
        }
    }
}

