/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.dpdk.core.lcore.analysis;

import java.util.Objects;
import org.eclipse.tracecompass.incubator.internal.dpdk.core.analysis.IDpdkEventHandler;
import org.eclipse.tracecompass.incubator.internal.dpdk.core.lcore.analysis.DpdkLogicalCoreEventLayout;
import org.eclipse.tracecompass.incubator.internal.dpdk.core.lcore.analysis.LogicalCore;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

public class DpdkLogicalCoreEventHandler
implements IDpdkEventHandler {
    private DpdkLogicalCoreEventLayout fLayout;

    DpdkLogicalCoreEventHandler(DpdkLogicalCoreEventLayout layout) {
        this.fLayout = layout;
    }

    @Override
    public void handleEvent(ITmfStateSystemBuilder ssb, ITmfEvent event) {
        Integer lcoreId = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{this.fLayout.fieldLcoreId()});
        long ts = event.getTimestamp().getValue();
        String eventName = event.getName();
        if (eventName.equals(this.fLayout.eventLcoreStateChange())) {
            Integer lcoreRole = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{this.fLayout.fieldLcoreState()});
            LogicalCore.setRole(ssb, LogicalCore.LogicalCoreRole.fromInt(Objects.requireNonNull(lcoreRole)), Objects.requireNonNull(lcoreId), ts);
        } else if (eventName.equals(this.fLayout.eventServiceLcoreStart())) {
            LogicalCore.setRole(ssb, LogicalCore.LogicalCoreRole.ROLE_SERVICE, Objects.requireNonNull(lcoreId), ts);
        } else if (eventName.equals(this.fLayout.eventServiceLcoreStop())) {
            LogicalCore.setRole(ssb, LogicalCore.LogicalCoreRole.ROLE_RTE, Objects.requireNonNull(lcoreId), ts);
        } else if (eventName.equals(this.fLayout.eventThreadLcoreStopped())) {
            LogicalCore.setStatus(ssb, LogicalCore.LogicalCoreStatus.IDLE, Objects.requireNonNull(lcoreId), ts);
            LogicalCore.setFunction(ssb, 0L, Objects.requireNonNull(lcoreId), ts);
        } else if (eventName.equals(this.fLayout.eventThreadLcoreRunning())) {
            LogicalCore.setStatus(ssb, LogicalCore.LogicalCoreStatus.RUNNING, Objects.requireNonNull(lcoreId), ts);
            Long lcoreFunction = (Long)event.getContent().getFieldValue(Long.class, new String[]{this.fLayout.fieldF()});
            LogicalCore.setFunction(ssb, Objects.requireNonNull(lcoreFunction), lcoreId, ts);
        } else if (eventName.equals(this.fLayout.eventThreadLcoreReady())) {
            LogicalCore.setRole(ssb, LogicalCore.LogicalCoreRole.ROLE_RTE, Objects.requireNonNull(lcoreId), ts);
            LogicalCore.setFunction(ssb, 0L, Objects.requireNonNull(lcoreId), ts);
        }
    }
}

