/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros.core.trace;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.ros.core.trace.layout.IRosEventLayout;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.trace.TraceValidationStatus;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEventFactory;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTraceValidationStatus;

public class RosTrace
extends CtfTmfTrace {
    private static final int CONFIDENCE = 101;
    private static final @NonNull Collection<ITmfEventAspect<?>> ROS_ASPECTS;
    private @NonNull Collection<ITmfEventAspect<?>> fRosTraceAspects = ImmutableSet.copyOf(ROS_ASPECTS);
    private @Nullable IRosEventLayout fLayout = null;

    static {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll((Iterable)CtfTmfTrace.CTF_ASPECTS).build();
        ROS_ASPECTS = builder.build();
    }

    public RosTrace() {
        super(CtfTmfEventFactory.instance());
    }

    protected RosTrace(@NonNull CtfTmfEventFactory factory) {
        super(factory);
    }

    public @NonNull IRosEventLayout getEventLayout() {
        IRosEventLayout layout = this.fLayout;
        if (layout == null) {
            throw new IllegalStateException("Cannot get the layout of a non-initialized trace!");
        }
        return layout;
    }

    public void initTrace(IResource resource, String path, Class<? extends ITmfEvent> eventType) throws TmfTraceException {
        IRosEventLayout layout;
        super.initTrace(resource, path, eventType);
        this.fLayout = layout = RosTrace.getLayout();
    }

    private static @NonNull IRosEventLayout getLayout() {
        return Objects.requireNonNull(IRosEventLayout.getDefault());
    }

    public Iterable<ITmfEventAspect<?>> getEventAspects() {
        return this.fRosTraceAspects;
    }

    public IStatus validate(IProject project, String path) {
        IStatus status = super.validate(project, path);
        if (status instanceof CtfTraceValidationStatus) {
            Collection eventNames = ((CtfTraceValidationStatus)status).getEventNames();
            if (!eventNames.stream().anyMatch(event -> event.startsWith("roscpp:"))) {
                return new Status(4, "org.eclipse.tracecompass.incubator.ros.core", "The trace is not a ROS trace.");
            }
            int conf = 101;
            conf = (int)((long)conf + eventNames.stream().filter(eventName -> RosTrace.getLayout().getEventNames().contains(eventName)).count());
            return new TraceValidationStatus(conf, "org.eclipse.tracecompass.incubator.ros.core");
        }
        return status;
    }
}

