/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.debugging.events.debugger;

import org.eclipse.debug.core.model.IWatchExpressionListener;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.ease.debugging.events.AbstractEvent;
import org.eclipse.ease.debugging.events.debugger.IDebuggerEvent;
import org.eclipse.ease.debugging.model.EaseDebugElement;
import org.eclipse.ease.debugging.model.EaseWatchExpressionResult;

public class EvaluateExpressionEvent
extends AbstractEvent
implements IDebuggerEvent {
    private final String fExpression;
    private final Object fResult;
    private final Throwable fException;
    private final IWatchExpressionListener fListener;

    public EvaluateExpressionEvent(String expression, Object result, Throwable exception, IWatchExpressionListener listener) {
        this.fExpression = expression;
        this.fResult = result;
        this.fException = exception;
        this.fListener = listener;
    }

    public Object getResult() {
        return this.fResult;
    }

    public Throwable getException() {
        return this.fException;
    }

    public IWatchExpressionListener getListener() {
        return this.fListener;
    }

    public IWatchExpressionResult getWatchExpressionResult(EaseDebugElement debugElement) {
        return new EaseWatchExpressionResult(this.fExpression, this.fResult, this.fException, debugElement);
    }

    @Override
    public String toString() {
        if (this.getException() != null) {
            return String.valueOf(super.toString()) + " (throws " + this.getException().getClass().getName() + ")";
        }
        return String.valueOf(super.toString()) + " (" + this.getResult() + ")";
    }
}

