/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;

public abstract class TableEditorImpl {
    private CellEditor fCellEditor;
    private CellEditor[] fCellEditors;
    private ICellModifier fCellModifier;
    private String[] fColumnProperties;
    private Item fTableItem;
    private int fColumnNumber;
    private ICellEditorListener fCellEditorListener;
    private FocusListener fFocusListener;
    private MouseListener fMouseListener;
    private int fDoubleClickExpirationTime;
    private final StructuredViewer fViewer;

    TableEditorImpl(StructuredViewer viewer) {
        this.fViewer = viewer;
        this.initCellEditorListener();
    }

    public StructuredViewer getViewer() {
        return this.fViewer;
    }

    private void activateCellEditor() {
        String property;
        Object element;
        if (this.fCellEditors != null && this.fCellEditors[this.fColumnNumber] != null && this.fCellModifier != null && this.fCellModifier.canModify(element = this.fTableItem.getData(), property = this.fColumnProperties[this.fColumnNumber])) {
            this.fCellEditor = this.fCellEditors[this.fColumnNumber];
            this.fCellEditor.addListener(this.fCellEditorListener);
            Object value = this.fCellModifier.getValue(element, property);
            this.fCellEditor.setValue(value);
            final Control control = this.fCellEditor.getControl();
            this.fCellEditor.activate();
            if (control == null) {
                return;
            }
            this.setLayoutData(this.fCellEditor.getLayoutData());
            this.setEditor(control, this.fTableItem, this.fColumnNumber);
            this.fCellEditor.setFocus();
            if (this.fFocusListener == null) {
                this.fFocusListener = new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        TableEditorImpl.this.applyEditorValue();
                    }
                };
            }
            control.addFocusListener(this.fFocusListener);
            this.fMouseListener = new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    if (e.time <= TableEditorImpl.this.fDoubleClickExpirationTime) {
                        control.removeMouseListener(TableEditorImpl.this.fMouseListener);
                        TableEditorImpl.this.cancelEditing();
                        TableEditorImpl.this.handleDoubleClickEvent();
                    } else if (TableEditorImpl.this.fMouseListener != null) {
                        control.removeMouseListener(TableEditorImpl.this.fMouseListener);
                    }
                }
            };
            control.addMouseListener(this.fMouseListener);
        }
    }

    private void activateCellEditor(MouseEvent event) {
        int columnToEdit;
        if (this.fTableItem == null || this.fTableItem.isDisposed()) {
            return;
        }
        int columns = this.getColumnCount();
        if (columns == 0) {
            columnToEdit = 0;
        } else {
            columnToEdit = -1;
            int i = 0;
            while (i < columns) {
                Rectangle bounds = this.getBounds(this.fTableItem, i);
                if (bounds.contains(event.x, event.y)) {
                    columnToEdit = i;
                    break;
                }
                ++i;
            }
            if (columnToEdit == -1) {
                return;
            }
        }
        this.fColumnNumber = columnToEdit;
        this.activateCellEditor();
    }

    public void applyEditorValue() {
        CellEditor c = this.fCellEditor;
        if (c != null) {
            this.fCellEditor = null;
            Item t = this.fTableItem;
            if (t != null && !t.isDisposed()) {
                this.saveEditorValue(c, t);
            }
            this.setEditor(null, null, 0);
            c.removeListener(this.fCellEditorListener);
            Control control = c.getControl();
            if (control != null) {
                if (this.fMouseListener != null) {
                    control.removeMouseListener(this.fMouseListener);
                }
                if (this.fFocusListener != null) {
                    control.removeFocusListener(this.fFocusListener);
                }
            }
            c.deactivate();
        }
    }

    public void cancelEditing() {
        if (this.fCellEditor != null) {
            this.setEditor(null, null, 0);
            this.fCellEditor.removeListener(this.fCellEditorListener);
            CellEditor oldEditor = this.fCellEditor;
            this.fCellEditor = null;
            oldEditor.deactivate();
        }
    }

    public void editElement(Object element, int column) {
        if (this.fCellEditor != null) {
            this.applyEditorValue();
        }
        this.setSelection(new StructuredSelection(element), true);
        Item[] selection = this.getSelection();
        if (selection.length != 1) {
            return;
        }
        this.fTableItem = selection[0];
        this.showSelection();
        this.fColumnNumber = column;
        this.activateCellEditor();
    }

    abstract Rectangle getBounds(Item var1, int var2);

    public CellEditor[] getCellEditors() {
        return this.fCellEditors;
    }

    public ICellModifier getCellModifier() {
        return this.fCellModifier;
    }

    abstract int getColumnCount();

    public Object[] getColumnProperties() {
        return this.fColumnProperties;
    }

    abstract Item[] getSelection();

    public void handleMouseDown(MouseEvent event) {
        if (event.button != 1) {
            return;
        }
        if (this.fCellEditor != null) {
            this.applyEditorValue();
        }
        this.fDoubleClickExpirationTime = event.time + Display.getCurrent().getDoubleClickTime();
        Item[] items = this.getSelection();
        if (items.length != 1) {
            this.fTableItem = null;
            return;
        }
        this.fTableItem = items[0];
        this.activateCellEditor(event);
    }

    private void initCellEditorListener() {
        this.fCellEditorListener = new ICellEditorListener(){

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            }

            public void cancelEditor() {
                TableEditorImpl.this.cancelEditing();
            }

            public void applyEditorValue() {
                TableEditorImpl.this.applyEditorValue();
            }
        };
    }

    public boolean isCellEditorActive() {
        return this.fCellEditor != null;
    }

    private void saveEditorValue(CellEditor cellEditor, Item tableItem) {
        if (this.fCellModifier != null) {
            cellEditor.isValueValid();
            String property = null;
            if (this.fColumnProperties != null && this.fColumnNumber < this.fColumnProperties.length) {
                property = this.fColumnProperties[this.fColumnNumber];
            }
            this.fCellModifier.modify((Object)tableItem, property, cellEditor.getValue());
        }
    }

    public void setCellEditors(CellEditor[] editors) {
        this.fCellEditors = editors;
    }

    public void setCellModifier(ICellModifier modifier) {
        this.fCellModifier = modifier;
    }

    public void setColumnProperties(String[] columnProperties) {
        this.fColumnProperties = columnProperties;
    }

    abstract void setEditor(Control var1, Item var2, int var3);

    abstract void setLayoutData(CellEditor.LayoutData var1);

    abstract void setSelection(StructuredSelection var1, boolean var2);

    abstract void showSelection();

    abstract void handleDoubleClickEvent();
}

