/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.event;

import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.junit.Assert;
import org.junit.Test;

public class TmfTimeRangeTest {
    @Test
    public void testConstructor() {
        ITmfTimestamp ts1 = TmfTimestamp.fromSeconds((long)12345L);
        ITmfTimestamp ts2 = TmfTimestamp.fromSeconds((long)12350L);
        TmfTimeRange range = new TmfTimeRange(ts1, ts2);
        Assert.assertEquals((String)"startTime", (Object)ts1, (Object)range.getStartTime());
        Assert.assertEquals((String)"endTime", (Object)ts2, (Object)range.getEndTime());
    }

    @Test
    public void testOpenRange1() {
        ITmfTimestamp ts2 = TmfTimestamp.fromSeconds((long)12350L);
        TmfTimeRange range = new TmfTimeRange(TmfTimestamp.BIG_BANG, ts2);
        Assert.assertEquals((String)"startTime", (Object)TmfTimestamp.BIG_BANG, (Object)range.getStartTime());
        Assert.assertEquals((String)"endTime", (Object)ts2, (Object)range.getEndTime());
    }

    @Test
    public void testOpenRange2() {
        ITmfTimestamp ts1 = TmfTimestamp.fromSeconds((long)12345L);
        TmfTimeRange range = new TmfTimeRange(ts1, TmfTimestamp.BIG_CRUNCH);
        Assert.assertEquals((String)"startTime", (Object)ts1, (Object)range.getStartTime());
        Assert.assertEquals((String)"endTime", (Object)TmfTimestamp.BIG_CRUNCH, (Object)range.getEndTime());
    }

    @Test
    public void testOpenRange3() {
        TmfTimeRange range = new TmfTimeRange(TmfTimestamp.BIG_BANG, TmfTimestamp.BIG_CRUNCH);
        Assert.assertEquals((String)"startTime", (Object)TmfTimestamp.BIG_BANG, (Object)range.getStartTime());
        Assert.assertEquals((String)"endTime", (Object)TmfTimestamp.BIG_CRUNCH, (Object)range.getEndTime());
    }

    @Test
    public void testHashCode() {
        ITmfTimestamp ts1 = TmfTimestamp.fromSeconds((long)12345L);
        ITmfTimestamp ts2 = TmfTimestamp.fromSeconds((long)12350L);
        TmfTimeRange range1 = new TmfTimeRange(ts1, ts2);
        TmfTimeRange range1b = new TmfTimeRange(ts1, ts2);
        TmfTimeRange range2 = new TmfTimeRange(TmfTimestamp.BIG_BANG, TmfTimestamp.BIG_CRUNCH);
        TmfTimeRange range2b = new TmfTimeRange(TmfTimestamp.BIG_BANG, TmfTimestamp.BIG_CRUNCH);
        Assert.assertTrue((String)"hashCode", (range1.hashCode() == range1b.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (range2.hashCode() == range2b.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (range1.hashCode() != range2.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsReflexivity() {
        ITmfTimestamp ts1 = TmfTimestamp.fromSeconds((long)12345L);
        ITmfTimestamp ts2 = TmfTimestamp.fromSeconds((long)12350L);
        TmfTimeRange range1 = new TmfTimeRange(ts1, ts2);
        TmfTimeRange range2 = new TmfTimeRange(TmfTimestamp.BIG_BANG, TmfTimestamp.BIG_CRUNCH);
        Assert.assertTrue((String)"equals", (boolean)range1.equals((Object)range1));
        Assert.assertTrue((String)"equals", (boolean)range2.equals((Object)range2));
        Assert.assertTrue((String)"equals", (!range1.equals((Object)range2) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!range2.equals((Object)range1) ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsSymmetry() {
        ITmfTimestamp ts1 = TmfTimestamp.fromSeconds((long)12345L);
        ITmfTimestamp ts2 = TmfTimestamp.fromSeconds((long)12350L);
        TmfTimeRange range1a = new TmfTimeRange(ts1, ts2);
        TmfTimeRange range1b = new TmfTimeRange(ts1, ts2);
        TmfTimeRange range2a = new TmfTimeRange(TmfTimestamp.BIG_BANG, TmfTimestamp.BIG_CRUNCH);
        TmfTimeRange range2b = new TmfTimeRange(TmfTimestamp.BIG_BANG, TmfTimestamp.BIG_CRUNCH);
        Assert.assertTrue((String)"equals", (boolean)range1a.equals((Object)range1b));
        Assert.assertTrue((String)"equals", (boolean)range1b.equals((Object)range1a));
        Assert.assertTrue((String)"equals", (boolean)range2a.equals((Object)range2b));
        Assert.assertTrue((String)"equals", (boolean)range2b.equals((Object)range2a));
    }

    @Test
    public void testEqualsTransivity() {
        ITmfTimestamp ts1 = TmfTimestamp.fromSeconds((long)12345L);
        ITmfTimestamp ts2 = TmfTimestamp.fromSeconds((long)12350L);
        TmfTimeRange range1a = new TmfTimeRange(ts1, ts2);
        TmfTimeRange range1b = new TmfTimeRange(ts1, ts2);
        TmfTimeRange range1c = new TmfTimeRange(ts1, ts2);
        Assert.assertTrue((String)"equals", (boolean)range1a.equals((Object)range1b));
        Assert.assertTrue((String)"equals", (boolean)range1b.equals((Object)range1c));
        Assert.assertTrue((String)"equals", (boolean)range1a.equals((Object)range1c));
    }

    @Test
    public void testEqualsNull() {
        ITmfTimestamp ts2;
        ITmfTimestamp ts1 = TmfTimestamp.fromSeconds((long)12345L);
        TmfTimeRange range1 = new TmfTimeRange(ts1, ts2 = TmfTimestamp.fromSeconds((long)12350L));
        Assert.assertTrue((String)"equals", (!range1.equals(null) ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsBadType() {
        ITmfTimestamp ts2;
        ITmfTimestamp ts1 = TmfTimestamp.fromSeconds((long)12345L);
        TmfTimeRange range1 = new TmfTimeRange(ts1, ts2 = TmfTimestamp.fromSeconds((long)12350L));
        Assert.assertTrue((String)"equals", (!range1.equals((Object)ts1) ? 1 : 0) != 0);
    }

    @Test
    public void testEqualStartTime() {
        ITmfTimestamp ts1 = TmfTimestamp.fromSeconds((long)12345L);
        ITmfTimestamp ts2 = TmfTimestamp.fromSeconds((long)12350L);
        ITmfTimestamp ts3 = TmfTimestamp.fromSeconds((long)12355L);
        TmfTimeRange range1 = new TmfTimeRange(ts1, ts3);
        TmfTimeRange range2 = new TmfTimeRange(ts2, ts3);
        TmfTimeRange range3 = new TmfTimeRange(ts1, ts2);
        Assert.assertTrue((String)"equals", (!range1.equals((Object)range2) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!range1.equals((Object)range3) ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsEndTime() {
        ITmfTimestamp ts1 = TmfTimestamp.fromSeconds((long)12345L);
        ITmfTimestamp ts2 = TmfTimestamp.fromSeconds((long)12350L);
        ITmfTimestamp ts3 = TmfTimestamp.fromSeconds((long)12355L);
        TmfTimeRange range1 = new TmfTimeRange(ts1, ts2);
        TmfTimeRange range2 = new TmfTimeRange(ts1, ts3);
        TmfTimeRange range3 = new TmfTimeRange(ts2, ts3);
        Assert.assertTrue((String)"equals", (!range1.equals((Object)range2) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!range1.equals((Object)range3) ? 1 : 0) != 0);
    }

    @Test
    public void testToString() {
        ITmfTimestamp ts1 = TmfTimestamp.fromSeconds((long)12345L);
        ITmfTimestamp ts2 = TmfTimestamp.fromSeconds((long)12350L);
        TmfTimeRange range = new TmfTimeRange(ts1, ts2);
        String expected = "TmfTimeRange [fStartTime=" + String.valueOf(ts1) + ", fEndTime=" + String.valueOf(ts2) + "]";
        Assert.assertEquals((String)"toString", (Object)expected, (Object)range.toString());
    }

    @Test
    public void testContainsTimestamp() {
        ITmfTimestamp ts1 = TmfTimestamp.fromSeconds((long)12345L);
        ITmfTimestamp ts2 = TmfTimestamp.fromSeconds((long)12350L);
        TmfTimeRange range = new TmfTimeRange(ts1, ts2);
        Assert.assertTrue((String)"contains (lower bound)", (boolean)range.contains(TmfTimestamp.fromSeconds((long)12345L)));
        Assert.assertTrue((String)"contains (higher bound)", (boolean)range.contains(TmfTimestamp.fromSeconds((long)12350L)));
        Assert.assertTrue((String)"contains (within bounds)", (boolean)range.contains(TmfTimestamp.fromSeconds((long)12346L)));
        Assert.assertFalse((String)"contains (low value)", (boolean)range.contains(TmfTimestamp.fromSeconds((long)12340L)));
        Assert.assertFalse((String)"contains (high value)", (boolean)range.contains(TmfTimestamp.fromSeconds((long)12351L)));
    }

    @Test
    public void testContainsRange() {
        ITmfTimestamp ts1 = TmfTimestamp.fromSeconds((long)10L);
        ITmfTimestamp ts2 = TmfTimestamp.fromSeconds((long)20L);
        ITmfTimestamp ts3 = TmfTimestamp.fromSeconds((long)30L);
        ITmfTimestamp ts4 = TmfTimestamp.fromSeconds((long)40L);
        ITmfTimestamp ts5 = TmfTimestamp.fromSeconds((long)50L);
        ITmfTimestamp ts6 = TmfTimestamp.fromSeconds((long)60L);
        ITmfTimestamp ts7 = TmfTimestamp.fromSeconds((long)70L);
        ITmfTimestamp ts8 = TmfTimestamp.fromSeconds((long)80L);
        TmfTimeRange range0 = new TmfTimeRange(ts3, ts6);
        TmfTimeRange range1 = new TmfTimeRange(ts1, ts2);
        TmfTimeRange range2 = new TmfTimeRange(ts2, ts3);
        TmfTimeRange range3 = new TmfTimeRange(ts2, ts4);
        TmfTimeRange range4 = new TmfTimeRange(ts2, ts6);
        TmfTimeRange range5 = new TmfTimeRange(ts2, ts7);
        Assert.assertFalse((String)"contains", (boolean)range0.contains(range1));
        Assert.assertFalse((String)"contains", (boolean)range0.contains(range2));
        Assert.assertFalse((String)"contains", (boolean)range0.contains(range3));
        Assert.assertFalse((String)"contains", (boolean)range0.contains(range4));
        Assert.assertFalse((String)"contains", (boolean)range0.contains(range5));
        TmfTimeRange range6 = new TmfTimeRange(ts3, ts7);
        TmfTimeRange range7 = new TmfTimeRange(ts4, ts7);
        TmfTimeRange range8 = new TmfTimeRange(ts6, ts7);
        TmfTimeRange range9 = new TmfTimeRange(ts7, ts8);
        Assert.assertFalse((String)"contains", (boolean)range0.contains(range6));
        Assert.assertFalse((String)"contains", (boolean)range0.contains(range7));
        Assert.assertFalse((String)"contains", (boolean)range0.contains(range8));
        Assert.assertFalse((String)"contains", (boolean)range0.contains(range9));
        TmfTimeRange range10 = new TmfTimeRange(ts3, ts4);
        TmfTimeRange range11 = new TmfTimeRange(ts3, ts6);
        TmfTimeRange range12 = new TmfTimeRange(ts4, ts5);
        TmfTimeRange range13 = new TmfTimeRange(ts4, ts6);
        Assert.assertTrue((String)"contains", (boolean)range0.contains(range10));
        Assert.assertTrue((String)"contains", (boolean)range0.contains(range11));
        Assert.assertTrue((String)"contains", (boolean)range0.contains(range12));
        Assert.assertTrue((String)"contains", (boolean)range0.contains(range13));
    }

    @Test
    public void testGetIntersection() {
        ITmfTimestamp ts1a = TmfTimestamp.fromSeconds((long)1000L);
        ITmfTimestamp ts1b = TmfTimestamp.fromSeconds((long)2000L);
        TmfTimeRange range1 = new TmfTimeRange(ts1a, ts1b);
        ITmfTimestamp ts2a = TmfTimestamp.fromSeconds((long)2000L);
        ITmfTimestamp ts2b = TmfTimestamp.fromSeconds((long)3000L);
        TmfTimeRange range2 = new TmfTimeRange(ts2a, ts2b);
        ITmfTimestamp ts3a = TmfTimestamp.fromSeconds((long)3000L);
        ITmfTimestamp ts3b = TmfTimestamp.fromSeconds((long)4000L);
        TmfTimeRange range3 = new TmfTimeRange(ts3a, ts3b);
        ITmfTimestamp ts4a = TmfTimestamp.fromSeconds((long)1500L);
        ITmfTimestamp ts4b = TmfTimestamp.fromSeconds((long)2500L);
        TmfTimeRange range4 = new TmfTimeRange(ts4a, ts4b);
        ITmfTimestamp ts5a = TmfTimestamp.fromSeconds((long)1500L);
        ITmfTimestamp ts5b = TmfTimestamp.fromSeconds((long)2000L);
        TmfTimeRange range5 = new TmfTimeRange(ts5a, ts5b);
        ITmfTimestamp ts6a = TmfTimestamp.fromSeconds((long)2000L);
        ITmfTimestamp ts6b = TmfTimestamp.fromSeconds((long)2500L);
        TmfTimeRange range6 = new TmfTimeRange(ts6a, ts6b);
        ITmfTimestamp ts7a = TmfTimestamp.fromSeconds((long)1500L);
        ITmfTimestamp ts7b = TmfTimestamp.fromSeconds((long)3500L);
        TmfTimeRange range7 = new TmfTimeRange(ts7a, ts7b);
        ITmfTimestamp ts8a = TmfTimestamp.fromSeconds((long)2250L);
        ITmfTimestamp ts8b = TmfTimestamp.fromSeconds((long)2750L);
        TmfTimeRange range8 = new TmfTimeRange(ts8a, ts8b);
        Assert.assertEquals((String)"getIntersection (below - not contiguous)", null, (Object)range1.getIntersection(range3));
        Assert.assertEquals((String)"getIntersection (above - not contiguous)", null, (Object)range3.getIntersection(range1));
        Assert.assertEquals((String)"getIntersection (below - contiguous)", (Object)new TmfTimeRange(ts1b, ts1b), (Object)range1.getIntersection(range2));
        Assert.assertEquals((String)"getIntersection (above - contiguous)", (Object)new TmfTimeRange(ts3a, ts3a), (Object)range3.getIntersection(range2));
        Assert.assertEquals((String)"getIntersection (below - overlap)", (Object)new TmfTimeRange(ts2a, ts4b), (Object)range2.getIntersection(range4));
        Assert.assertEquals((String)"getIntersection (above - overlap)", (Object)new TmfTimeRange(ts2a, ts4b), (Object)range4.getIntersection(range2));
        Assert.assertEquals((String)"getIntersection (within - overlap1)", (Object)range6, (Object)range2.getIntersection(range6));
        Assert.assertEquals((String)"getIntersection (within - overlap2)", (Object)range6, (Object)range6.getIntersection(range2));
        Assert.assertEquals((String)"getIntersection (within - overlap3)", (Object)range5, (Object)range1.getIntersection(range5));
        Assert.assertEquals((String)"getIntersection (within - overlap4)", (Object)range5, (Object)range5.getIntersection(range1));
        Assert.assertEquals((String)"getIntersection (within - overlap5)", (Object)range8, (Object)range2.getIntersection(range8));
        Assert.assertEquals((String)"getIntersection (within - overlap6)", (Object)range8, (Object)range8.getIntersection(range2));
        Assert.assertEquals((String)"getIntersection (accross1)", (Object)range2, (Object)range2.getIntersection(range7));
        Assert.assertEquals((String)"getIntersection (accross2)", (Object)range2, (Object)range7.getIntersection(range2));
    }
}

